#ifndef PHYCPP_TREE_TAXON_HPP
#define PHYCPP_TREE_TAXON_HPP

#include "../utility/labelledobject.hpp"
#include "../utility/valuedobject.hpp"
#include "../utility/stringalgorithm.hpp"

namespace PhyCpp {

template <typename T>
class BasicTaxon : private UniquelyLabelledObject<std::string, BasicTaxon<T> >,
                   public ValuedObject<T> {

	PHYCPP_DECLARE_UNIQUELY_LABELLED

public:

	typedef T value_type;

	inline ~BasicTaxon() {
	}

	inline bool setLabel(const std::string & label) {
		if (isWhiteSpaceOnly(label))
			return false;
		return UniquelyLabelledObject<std::string, BasicTaxon<T> >::setLabel(label);
	}

	inline const std::string & label() const {
		return UniquelyLabelledObject<std::string, BasicTaxon<T> >::label();
	}

protected:

	inline BasicTaxon(const std::string & label, UniquelyLabelledObjectManager<std::string, BasicTaxon<T> > * manager)
		: UniquelyLabelledObject<std::string, BasicTaxon<T> > (label, manager),
		  ValuedObject<T>() {
	}
};

}

#endif // PHYCPP_TREE_TAXON_HPP
