#ifndef PHYCPP_UTILITY_STRINGALGORITHM_HPP
#define PHYCPP_UTILITY_STRINGALGORITHM_HPP

#include <string>
#include <cctype>
#include <algorithm>

namespace PhyCpp {

static bool isWhiteSpaceOnly(const std::string & str) {
	std::string::const_iterator it = str.begin();
	while (it != str.end()) {
		if (!isspace(*it))
			return false;
		++it;
	}
	return true;
}

static inline std::string trimWhiteSpace(const std::string & string) {
	std::string::const_iterator it = string.begin();
	std::string::const_iterator it2 = string.end() - 1;
	while (it <= it2 && isspace(*it))
		++it;
	while (it2 >= it && isspace(*it2))
		--it2;
	return std::string(it, it2+1);
}

static inline std::string stripWhiteSpace(const std::string & string) {
	std::string result;
	std::string::const_iterator it = string.begin();
	std::string::const_iterator ite = string.end();
	while (it != ite) {
		if (!isspace(*it))
			result += *it;
		++it;
	}
	return result;
}

}

#endif // STRINGALGORITHM_HPP
