#ifndef PHYCPP_UTILITY_VALUEDOBJECT_HPP
#define PHYCPP_UTILITY_VALUEDOBJECT_HPP

namespace PhyCpp {

template <typename T>
class ValuedObject {

public:

	typedef T value_type;

	inline ValuedObject() : valueData() {}
	inline ValuedObject(T & value): valueData(value) {}
	virtual ~ValuedObject() {}

	inline const T & value() const {return valueData;}
	inline T & value() {return valueData;}
	inline void setValue(const T & value) {valueData = value;}

	inline void swapValuesWith(ValuedObject<T> * other) {
		std::swap(valueData, other->valueData);
	}

private:

	T valueData;
};

template <>
class ValuedObject<void> {

public:

	typedef void value_type;

	inline ValuedObject() {}
	virtual ~ValuedObject() {}

        inline void swapValuesWith(ValuedObject<void> *) {}
};

}

#endif // PHYCPP_UTILITY_VALUEDOBJECT_HPP
