#ifndef CHAINMANAGER_H
#define CHAINMANAGER_H

#define _USE_MATH_DEFINES
#include <cmath>
#include <string>
#include "../treedef.h"
#include "chain.h"

class ChainManager
{
public:
	
	ChainManager(long seed, int numStages, int numChains, const std::string & treePath, const std::string & dataPath, const std::string & outputBasePath, int numGens, int thinning, double igshape, double igscale, bool brownian, bool brownianstrict);
	~ChainManager();
	
	const std::string & error() const {return errorMsg;}
	double logL(double stable_alpha, double stable_scale) const;
	bool go();
	void reportProgress(int id, int iter, double L);
	
private:

	int numStages;
	int numChains;
	std::string errorMsg;
	std::vector<Chain*> chains;
	Tree * tree;
	Taxa *taxa;
	double igamma_shape;
	double igamma_scale;
	double lgamshape;
	int numgens;
	int printfreq;
	std::vector<int> iters;
	std::vector<double> Ls;
	std::string outPath;
	std::ofstream ofs;
};

#endif // CHAINMANAGER_H
