#ifndef GLOBAL_H
#define GLOBAL_H

#define _USE_MATH_DEFINES
#include <cmath>

#define MULTITHREADED // UNDEFINE TO GET A SINGLE THREADED VERSION
//#define FASTMATH // UNDEFINE TO GET SLOWER BUT DOUBLE VERSUS FLOAT ACCURACY 
#define LINEAR_INTERPOLATION // UNDEFINE TO GET CUBIC_INTERPOLATION, SLOWER BUT MORE ACCURATE

#define SQRT2PI 2.5066282746310002
#define SQRT2 1.4142135623730951

#ifdef FASTMATH

	#include "fmath.hpp"

	inline double fastPow(double a, double b) {
	  union {
		double d;
		int x[2];
	  } u = { a };
	  u.x[1] = (int)(b * (u.x[1] - 1072632447) + 1072632447);
	  u.x[0] = 0;
	  return u.d;
	}

	inline double fastLog(double a) {
		return fmath::log((float)a);
	}

	#define LOG(a) fastLog(a)
	#define POW(a,b) fastPow(a,b)

#else

	#define LOG(a) log(a)
	#define POW(a,b) pow(a,b)

#endif // FASTMATH

#endif // GLOBAL_H
